//////////
//
//	File:		ComApplication.h
//
//	Contains:	Functions that could be overridden in a specific application.
//
//	Written by:	Tim Monroe
//				Based (heavily!) on the MovieShell code written by Apple DTS
//
//	Copyright:	 1994-1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <4>	 	09/11/97	rtm		merged MacApplication.h and WinApplication.h
//	   <3>	 	08/21/97	rtm		begun adding Windows support
//	   <2>	 	11/27/96	rtm		conversion to personal coding style
//	   <1>	 	12/21/94	khs		first file
//	   
//////////

#pragma once

//////////
// header files
//////////

#ifndef __QTUtilities__
#include "QTUtilities.h"
#endif

#include <MediaHandlers.h>
#include <Movies.h>
#include <Resources.h>
#include <Sound.h>
#include <SoundComponents.h>
#include <SoundSprocket.h>
#include <TextUtils.h>

#include <string.h>
#include <stdlib.h>

#if TARGET_OS_MAC
#include <AppleEvents.h>
#include "MacFramework.h"
#include "AppConfiguration.h"
#endif	// TARGET_OS_MAC

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif	// TARGET_OS_WIN32

#include "ComResource.h"

//////////
// constants
//////////

//////////
// structures
//////////

// application-specific data
typedef struct {
	Boolean						fMovieHasSprites;	// does the movie have a sprite track?
	MediaHandler				fSpriteHandler;		// the media handler for the sprite track
} ApplicationDataRecord, *ApplicationDataPtr, **ApplicationDataHdl;

//////////
// function prototypes
//////////

#if TARGET_OS_MAC
void					InstallAppleEventHandlers (void);
pascal OSErr			HandleOpenApplicationAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);			
pascal OSErr			HandleOpenDocumentAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
pascal OSErr			HandlePrintDocumentAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
pascal OSErr			HandleQuitApplicationAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
#endif	// TARGET_OS_MAC

// the other function prototypes are in the file MacFramework.h or WinFramework.h
